 ;************************************************************
;*       Betriebssoftware STASI-Funkgert von DL3CS         *
;* Disassembliert von DB1NV                 Stand: 26.12.99 *
;************************************************************
;*                                                          *
;* IO-Adressen:	PIO_A_DAT EQU 00010H                        *
;*		PIO_B_DAT EQU 00011H                        *
;* 		PIO_A_CTRL EQU 00012H                       *
;*		SIO_A_DAT EQU 00020H			    *
;*		SIO_B_DAT EQU 00021H                        *
;*		SIO_A_CTRL EQU 00022H                       *
;*		SIO_B_CTRL EQU 00023H                       *
;*		RTC_TEST EQU 00030H                         *
;*		RTC_SEC0 EQU 00032H                         *
;*		RTC_SEC1 EQU 00033H                         *
;*		RTC_MIN0 EQU 00034H                         *
;*		RTC_MIN1 EQU 00035H                         *
;*		RTC_STD0 EQU 00036H                         *
;*		RTC_STD1 EQU 00037H                         *
;*		RTC_START EQU 0003EH                        *
;*		RTC_INT EQU 0003FH                          *
;*                                                          *
;* der DCD-Eingang von SIO A wird zur Abfrage der           *
;* Einschalttaste (akt Low) verwendet, der CTS-Eingang von  *
;* SIO A geht zum Batteriespannungs-Komparator              *
;* Die Eingnge CTS und DCD tauchen invertiert im Status-   *
;* wort der SIO auf                                         *
;* Einschalttaste und Uhrinterrupt werden in einem NAND     *
;* zusammengefat und aktivieren die Einschaltogik          *
;*                                                          *
;* PIO Kanal A: A0...A3: Daten zum Synthesizer HEF4751V     *
;*		A4: Program Enable Synthesizer              *
;*       	    Der Program Clock wird aus Chip Select  *
;*		    der PIO erzeugt                         *
;*		A5: Lock Detect Synthesizer (?), akt. high  *
;*     		A6: Sendeleistung da (?), akt low           *
;*              A7: Uhrinterrupt MM58174 , akt. low         *
;*                                                          *
;* PIO Kanal B: B0: Einschaltkontrolle (grne LED)          *
;*		B1: Programmierkontrolle (gelbe LED)        *
;*      	B2: Sendertastung aktiv High                *
;* 		B3: Senderversorgung ein aktiv high         *
;*		B4: Reset Watchdog CD4060, aktiv high       *
;*		B5: Clock Ein/Aus-FF CD4013/1               *
;*		B6: Reset Sperr-FF CD4013/2, aktiv high     *
;*  		B7: (frei)                                  * 
;************************************************************
;* 	ROM_TAB1  EQU 00796H                                *
;*	ROM_TAB2  EQU 007A0H                                *
;*                                                          *
;*	NAME1     EQU 2000H ; Kennbyte, wird in Gerte-     *
;*                          ; kennstring im Spruchkopf      *
;*                          ; eingebaut (?), kommt bei      *
;*                          ; Frequenztabelle 1             *
;*	NAME2     EQU 2001H ; Kennbyte, wird in Gerte-     *
;*                          ; kennstring im Spruchkopf      *
;*                          ; eingebaut (?), F-Tabelle 2    *
;*                                                          *
;*	LAENGE    EQU 2002H ; Lnge Datenblock (?)          *
;*      KANAL     EQU 2003H ; Kanalnummer erster Datenblock *
;*                                                          *
;*	WECKZEIT1 EQU 2004H (4 Byte)                        *
;*	WECKZEIT2 EQU 2008H (4 Byte)                        *
;*                                                          *
;* 	PR_SUMME3 EQU 200CH (2 Byte) ; Prfsumme Text       *
;* 	PR_SUMME2 EQU 200EH (2 Byte) ; Prfsumme Tabelle 1  *
;* 	PR_SUMME1 EQU 2010H (2 Byte) ; Prfsumme Tabelle 2  *
;*                                                          *
;*                                                          *
;*	STAT_WORT EQU 2012H  ; Statusbits fr Sendevorgang  *
;*	Bit 0: Spruchspeicher 3 (Text) geladen              *
;*	Bit 1: Spruchspeicher 1 (Frequenzliste 1) geladen   *
;*	Bit 2: Spruchspeicher 2 (Frequenzliste 2) geladen   *
;*	Bit 3: Programmierung normal beendet                *
;*	Bit 4:                                              *
;*	Bit 5: Uhr gestellt                                 *
;*	Bit 6: Weckzeit (1) eingegeben                      *
;*	Bit 7: Weckzeit (2) eingegeben                      *
;*                                                          *
;*	MERKER    EQU 2013H  ; diverse Merkerbits           *
;*      Bit 1: Weckzeit 1 erreicht                          *
;*	Bit 3: Synthesizer-Fehler (Lock Detect)             *
;*                                                          *
;*	S_ZEIGER1 EQU 2014H  ; das 16-Bit-Wort zeigt auf    *
;*      die Anfangsadresse des zu sendenden Speichers       *
;*                                                          *
;*	S_ZEIGER2 EQU 2016H  ; 16-Bit-Zeiger auf einen der  *
;*	beiden kurzen Speicherblcke, vermutlich die Kanal- *
;*   	tabellen fr Frequency-Hopping-Betrieb              *
;*                                                          *
;*	FREQ_WORT EQU 2018H                                 *
;************************************************************



0000  ANFANG 	NOP
0001		NOP
0002		NOP
0003    	NOP
0004    	NOP
0005    	NOP
0006    	NOP
0007    	NOP
0008    	NOP
0009    	NOP
0010    	NOP
0011    	NOP
0012    	NOP
0013    	NOP
0014    	NOP
0015    	NOP
0016    	NOP
0017    	NOP
0018    	NOP
0019    	NOP
0020    	NOP
0021    	NOP
0022    	NOP
0023    	NOP
0024    	NOP
0025    	NOP
0026    	NOP
0027    	NOP
0028    	NOP
0029    	NOP
0030    	NOP
0031    	NOP
0032 START 	LD SP,3FFF
0033    	LD A,18H		; SIO rcksetzen
0034    	OUT (SIO_A_CTRL),A
0035    	OUT (SIO_A_CTRL),A
0036    	OUT (SIO_A_CTRL),A
0037    	OUT (SIO_A_CTRL),A
0038    	OUT (SIO_A_CTRL),A
0039	    	IN A,(PIO_A_DAT)
0040    	LD B,A
0041    	IN A,(RTC_INT)		; Interruptsystem Uhr rcksetzen
0042   		IN A,(RTC_INT)
0043    	IN A,(RTC_INT)
0044    	IN A,(PIO_B_DAT)
0045    	BIT 5,A			; Einschalt-FF testen
0046    	JR NZ,START_2
0047    	BIT 7,B			; Uhrinterrupt (PIO A7) testen, wenn noch da
0048    	JR Z,START_6		; liegt Fehler vor, daher zu NEUSTART
					; springen und wieder versuchen

0049   		CALL PIO_INIT
0050    	LD A,18H
0051    	OUT (PIO_B_DAT),A	; Watchdog aus, Senderversorgung ein
0052    	CALL ZEIT_SCHL1
0053    	CALL SIO_A_INI1
0054    	CALL MEM_INI1

0055    	LD DE,ROM_TAB2		; Zeiger auf Standard-Sendefrequenz
0056    	LD (2016H),DE		; in 2016 und 2017 ablegen
0057    	CALL SENDE_FRE		; kleiner Selbsttest des Senders
0058    	LD A,1BH
0059    	JR Z,START_1		; Selbsttest ok
0060    	LD A,19H
0061    	OUT (PIO_B_DAT),A	; Watchdog aus, Einschalt-LED und Sender-
0062    	CALL ZEIT_SCHL3		; versorgung ein
0063    	CALL ZEIT_SCHL3
0064    	JP ENDE

0065 START_1 	OUT (PIO_B_DAT),A	; Watchdog aus, Einschalt-LED und
0066    	CALL ZEIT_SCHL1		; Programmier-LED ein
0067    	CALL ZEIT_SCHL1
0068    	CALL SIO_AB_INI
0069    	JP KOM_DEC1		; Kommando decodieren

0070 START_2 	LD HL,2013H		; Testen, ob Speicher gelscht
0071    	LD A,0FFH		; d.h. alles erledigt
0072    	CP (HL)
0073    	JR NZ,START_4		; Wenn nein, dann weitermachen
0074    	IN A,(SIO_A_CTRL)	; Einschalttaste losgelassen?
0075    	BIT 3,A
0076    	JR Z,START_6		; zu NEUSTART springen
0077    	LD A,12H		; Watchdog aus, Programmier-LED an
0078    	OUT (PIO_B_DAT),A

0079 START_3 	LD A,10H		; warten, bis Taste losgelassen, dann 
0080    	OUT (SIO_A_CTRL),A	; von vorn beginnen
0081    	IN A,(SIO_A_CTRL)	;
0082    	BIT 3,A
0083    	JR NZ,START_3
0084    	CALL ZEIT_SCHL3
0085    	JP NEUSTART

0086 START_4 	IN A,(SIO_A_CTRL)	; DCD auf SIO A testen
0087    	BIT 3,A			; Tastendruck da?
0088    	JP NZ,S_AUFTR3		; dann weiter zu S_AUFTR3

0089 S_AUFTR8 	CALL READ_RTC		; Sendetermin 1 prfen
0090    	LD IX,2004H
0091    	CALL RTC_WECKER
0092    	JR Z,S_AUFTR10
0093    	LD IX,2008H		; Sendetermin 2 prfen
0094    	CALL RTC_WECKER
0095    	JR Z,S_AUFTR9
0096 START_6 	JP NEUSTART		; Noch kein Termin fllig!


0097 S_AUFTR9 	LD HL,2012H		; Sendetermin 2 erreicht!
0098    	BIT 6,(HL)		; Keine Gltige Weckzeit!
0099	 	JR Z,START_6		; zu NEUSTART springen
0100    	BIT 7,(HL)		; Keine gltige Weckzeit!
0101    	JR Z,START_6		; zu NEUSTART springen
0102    	LD DE,234AH		; Startadresse Sendespeicher 2 ist 234AH
0103    	JR S_AUFTR11		
					; 
0104 S_AUFTR10 	LD DE,2022H		; Sendetermin 1 erreicht!
0105    	LD HL,2012H		; Startadresse Sendespeicher 1 ist 2022H
0106    	BIT 7,(HL)		; nochmal auf gltige Weckzeit testen
0107    	JP Z,ENDE

0108 S_AUFTR11 	PUSH DE
0109    	CALL SIO_A_INI1		; SIO initialisieren
0110    	POP DE
0111    	LD A,19H		; Watchdog aus, Einschalt-LED ein,
0112    	OUT (PIO_B_DAT),A	; Senderversorgung ein
0113 S_AUFTR12 	LD (2016H),DE		; Beginn Sendespeicher 1 oder 2 nach 2016H
0114    	LD DE,2672H		; Anfang Sendespeicher 3 nach 2014H
0115    	LD (2014H),DE
0116 S_AUFTR13 	CALL ZEIT_SCHL3
0117    	CALL SENDE_FRE		; Sendefrequenz einstellen
0118    	JP NZ,ENDE		; testen, ob Sender ok
0119    	LD A,1BH		; Watchdog aus, Einschaltkontrolle und
0120    	OUT (PIO_B_DAT),A	; gelbe LED ein
0121    	CALL ZEIT_SCHL3
0122    	LD A,1FH		; Jetzt noch Sender tasten
0123    	OUT (PIO_B_DAT),A
0124    	CALL SEND_SIO1
0125    	CALL SEND_SIO1
0126    	LD B,2H
0127    	CALL SENDELOOP1		; Spruchkopf und 2 Byte senden, ist neue Frequenz 
0128    	LD B,5H			; neue Frequenz einstellen
0129    	CALL SET_TX2		; 
0130 S_AUFTR14 	CALL SENDELOOP		; Datenblock senden, Lnge steht in 2002H
0131    	CALL SET_TX1		; Frequenz neu einstellen, Kanal
0132    	JR S_AUFTR14		; steht in 2003H
					; Wenn Speicher leer, bricht Sendeloop ab

0133 READ_SER 	EXX			; Dieser Einsprung initialisiert
0134    	LD BC,0			; den Timeout-Zhler
0135    	EXX
0136 READ_SER1 	EXX			; hier luft der Zhler mit
0137    	DEC BC
0138    	LD A,B
0139    	OR C
0140    	EXX
0141    	JP Z,TIMEOUT		; nach 65536 Zugriffen abbrechen
0142    	IN A,(SIO_A_CTRL)	; Beide serielle Schnittstellen
0143    	BIT 0,A			; auf Zeichen testen
0144    	JR Z,READ_SER2
0145    	IN A,(SIO_A_DAT)	; Zeichen von SIO A holen
0146    	RET
0147 READ_SER2 	IN A,(SIO_B_CTRL)
0148    	BIT 0,A
0149    	JR Z,READ_SER1
0150 READ_SER3 	IN A,(SIO_B_DAT)	; Zeichen von SIO B holen
0151    	RET

0152 PIO_INIT 	LD A,0CFH		; PIO initialisieren, Uhr starten
0153    	OUT (PIO_A_CTRL),A	; Mode 3, Bitweise Ein/Ausgang
0154    	LD A,0E0H		; PIO A, Bit 0...4 Ausgang und
0155    	OUT (PIO_A_CTRL),A	; Bit 5...7 Eingang
0156    	OUT (RTC_TEST),A
0157    	LD A,0CFH		; Mode 3, Bitweise Ein/Ausgang
0158    	OUT (PIO_B_CTRL),A
0159    	LD A,80H		; Nur Bit 7 ist Eingang 
0160    	OUT (PIO_B_CTRL),A
0161    	LD A,0FFH
0162    	OUT (RTC_START),A
0163    	RET

0164 SIO_AB_INI PUSH HL			; SIO A und B auf Clock/32
0165    	PUSH BC			; fr Programmierbetrieb
0166    	LD HL,SIO_AB_TAB
0167    	LD C,SIO_A_CTRL
0168    	LD B,8
0169    	OTIR
0170    	LD C,SIO_B_CTRL
0171    	LD B,8
0172    	OTIR
0173    	POP BC
0174    	POP HL
0175    	RET
0176 SIO_AB_TAB DB 18H,18H
0177 		DB 04H
0178    	DB 0CH
0179    	DB 05H
0180    	DB 68H
0181    	DB 03H,C1H

0182 L0018 	INC B		; Codefragment?
0183    	CALL Z,0C103H

0184 MEM_INI1 	LD HL,2000H	; RAM von 2000 - 3FE0 lschen
0185    	LD DE,2001H
0186    	LD BC,1FE0H
0187    	LD (HL),0
0188    	LDIR
0189    	XOR A		; Uhrinhalt lschen
0190 	 	OUT (RTC_SEC0),A
0191    	OUT (RTC_SEC1),A
0192    	OUT (RTC_MIN0),A
0193 	 	OUT (RTC_MIN1),A
0194    	OUT (RTC_STD0),A
0195    	OUT (RTC_STD1),A
0196    	OUT (RTC_INT),A
0197		RET

0198 READ_RTC 	IN A,(RTC_SEC0)	; Uhr lesen
0199    	AND 0FH		; Auf DATA CHANGE testen
0200    	CP 0FH		; Ergebnis steht in BC, DE und HL
0201    	JR Z,READ_RTC
0202    	LD C,A
0203    	IN A,(RTC_SEC1)
0204    	AND 0FH
0205    	CP 0FH
0206    	JR Z,READ_RTC
0207 	 	LD B,A
0208 		IN A,(RTC_MIN0)
0209    	AND 0FH
0210    	CP 0FH
0211    	JR Z,READ_RTC
0212    	LD E,A
0213    	IN A,(RTC_MIN1)
0214    	AND 0FH
0215    	CP 0FH
0216    	JR Z,READ_RTC
0217    	LD D,A
0218    	IN A,(RTC_STD0)
0219    	AND 0FH
0220    	CP 0FH
0221    	JR Z,READ_RTC
0222    	LD L,A
0223    	IN A,(RTC_STD1)
0224    	AND 0FH
0225    	CP 0FH
0226    	JR Z,READ_RTC
0227    	LD H,A
0228    	RET

0229 L_SPRUCH 	LD HL,2012H	; Spruchspeicher laden, 6400 Zeichen
0230    	RES 0,(HL)	; Ist anscheinend der eigentliche Textspeicher
0231    	LD BC,1900H
0232    	LD HL,2677H	; Speicher beginnt ab 2677H
0233    	EXX
0234    	LD HL,0
0235    	PUSH HL
0236    	POP DE
0237    	EXX
0238 L_SPRUCHA	CALL READ_SER	; Zeichen werden direkt gespeichert
0239    	CP 0FFH
0240    	JR Z,L_SPRUCHB	; Endezeichen FFH erreicht?
0241    	EXX
0242    	LD E,A
0243    	ADD HL,DE
0244    	EXX
0245    	LD (HL),A
0246    	INC HL
0247    	DEC BC
0248    	LD A,B
0249    	OR C
0250    	JP Z,TIMEOUT
0251    	JR L_SPRUCHA

0252 L_SPRUCHB	LD A,0CCH
0253    	LD (HL),A
0254    	INC HL
0255    	LD (HL),A
0256    	INC HL
0257    	CALL READ_SER
0258    	CP 0FFH
0259    	JP NZ,TIMEOUT
0260    	LD (HL),A
0261    	INC HL
0262    	LD (HL),A
0263    	EXX
0264    	LD (200CH),HL		; Prfsumme Spruchspeicher 3
0265    	EXX
0266    	LD HL,2012H		; Bit 0 in 2012H: Spruchspeicher 3 geladen
0267    	SET 0,(HL)
0268    	JP KOM_DECX


0269 BIN_BCD 	PUSH BC		; Binrzahl in HL wird in gepackte
0270    	PUSH DE		; BCD-Zahl gewandelt	
0271    	LD DE,3E8H	; das ist 1000Dez
0272    	CALL DIV_HLDE1
0273    	CALL SWAP_A
0274    	LD DE,64H	; das ist 100Dez
0275    	CALL DIV_HLDE2
0276    	LD B,A
0277    	LD E,0AH
0278    	CALL DIV_HLDE1
0279    	CALL SWAP_A
0280    	OR L
0281    	LD H,B
0282    	LD L,A
0283    	POP DE
0284    	POP BC
0285    	RET

0286 DIV_HLDE1 	XOR A		; HL wird durch DE dividiert, Ergebnis in A
0287 DIV_HLDE2 	INC A		; Rest in HL
0288    	SBC HL,DE
0289    	JR NC,DIV_HLDE2
0290    	DEC A
0291    	ADD HL,DE
0292    	RET

0293 SWAP_A 	RLCA	; Halbbytes in Akku tauschen
0294    	RLCA
0295    	RLCA
0296    	RLCA
0297    	RET

0298 FTAB_EIN 	EXX		; Eingabe einer Zeichenkette in Speicher 
0299    	LD HL,0		; ist anscheinend die Frequenztabelle fr
0300    	PUSH HL		; den Frequency Hopping Betrieb
0301    	POP DE		; DE mit Null laden
0302    	EXX
0303    	LD D,0H
0304    	LD BC,192H	; Zeichenzhler, 400 Zeichen
0305 FTAB_LOOP 	CALL READ_SER
0306    	CP 0FFH		; FFH ist Eingabe-Ende
0307    	RET Z
0308    	LD HL,9D8H
0309    	LD E,A
0310    	EXX
0311    	LD E,A		; wird hier eine 16-Bit-Prfsumme gebildet?
0312    	ADD HL,DE
0313    	EXX
0314    	ADD HL,DE
0315    	LD (IX+0H),L
0316    	INC IX
0317    	LD (IX+0H),H
0318    	INC IX
0319    	DEC BC
0320    	LD A,B		; Zeichenzhler leer?
0321    	OR C
0322    	JR NZ,FTAB_LOOP
0323    	SCF
0324    	RET


0325 L_TABELLE1 LD IX,2024H	; Tabellenspeicher 1 seriell laden
0326    	LD HL,2012H	; 
0327    	RES 1,(HL)
0328    	CALL FTAB_EIN	; Jedes ASCII-Zeichen wird zu 9D8H addiert 
0329    	JP C,TIMEOUT	; und als 16-Bit-Wert abgelegt, sind das die 
0330    	CALL READ_SER	; 400 Sendefrequenzen des Frequency Hoppers
0331    	CP 0FFH		; Endezeichen FFH da?
0332    	JP NZ,TIMEOUT
0333    	LD (IX+0H),A	; zweimal FFH an Spruchspeicher-Ende
0334    	LD (IX+1H),A	; anhngen
0335    	EXX
0336    	LD (200EH),HL	; Prfsumme nach 200EH?
0337    	LD HL,2012H
0338    	SET 1,(HL)	; Bit 1 in 2012H: Speicher 1 geladen
0339    	JP KOM_DECX

0340 L_TABELLE2 LD IX,234CH	; Tabellenspeicher 2 seriell laden
0341    	LD HL,2012H
0342    	RES 2,(HL)
0343    	CALL FTAB_EIN	; Jedes ASCII-Zeichen wird zu 9D8H addiert
0344    	JP C,TIMEOUT	; und als 16-Bit-Wert abgelegt, sind das die
0345    	CALL READ_SER	; 400 Sendefrequenzen des Frequency Hoppers
0346    	CP 0FFH		; Ende erreicht?
0347    	JP NZ,TIMEOUT
0348    	LD (IX+0H),A
0349    	LD (IX+1H),A
0350    	EXX
0351    	LD (2010H),HL	; Prfsumme nach 2010H
0352    	LD HL,2012H
0353    	SET 2,(HL)
0354    	JP KOM_DECX


0355 MOV_ROM1 	LD HL,ROM_TAB1	; 10 Bytes von 796H (EPROM)
0356    	LD DE,2018H	; ins RAM kopieren
0357		LD BC,000AH	; ist anscheinend Default-Sendefrequenz!
0358    	LDIR
0359    	RET

0360 BCD2_BIN 	PUSH BC		; Gepackte BCD-Zahl in Binr konvertieren
0361    	PUSH AF
0362    	CALL SWAP_A
0363    	AND 0FH
0364    	LD B,A
0365    	INC B
0366    	POP AF
0367    	AND 0FH
0368 BCD2_BIN1 	ADD A,0AH
0369    	DJNZ BCD2_BIN1
0370    	SUB 0AH
0371    	POP BC
0372    	RET

0373 KOM_DEC2 	IN A,(PIO_B_DAT)	; Hier landen wir, wenn auf einer SIO 
0374    	SET 1,A			; ein Zeichen angekommen ist
0375 	L002E 	OUT (PIO_B_DAT),A	; Grne LED einschalten
0376    	CALL READ_SER
0377    	CP 0FFH			; Erstes Zeichen muss FF sein!
0378    	JP NZ,KOM_DECX
0379 KOM_DEC21 	CALL READ_SER		; Weitere FF ignorieren
0380    	CP 0FFH
0381    	JR Z,KOM_DEC21
0382	    	LD HL,7A7H		; Hier wird ein Tabellenzeiger durch
0383    	CP 1H			; Eingabe von 1,2,4,8 eingestellt
0384    	JR Z,KOM_DEC22		; und zum entsprechenden Teilprogramm
0385    	INC HL			; verzweigt
0386    	INC HL
0387    	CP 2H
0388    	JR Z,KOM_DEC22
0389    	INC HL
0390    	INC HL
0391    	CP 4H
0392    	JR Z,KOM_DEC22
0393    	INC HL
0394    	INC HL
0395    	CP 8H
0396    	JR Z,KOM_DEC22
0397    	INC HL
0398    	INC HL
0399    	CP 11H
0400    	JR Z,KOM_DEC22
0401    	JP TX_TEST_A
0402 KOM_DEC22 	LD A,(HL)
0403    	INC HL
0404    	LD H,(HL)
0405    	LD L,A
0406    	JP (HL)			; Kommando in Unterprogramm ausfhren 


0407 ASCII_BCD2 CALL READ_SER	; Zwei ASCII-Zeichen, Blank und Ziffer
0408    	CP 20H		; in BCD wandeln
0409    	JP NZ,TIMEOUT

0410 ASCII_BCD 	CALL READ_SER	; Liest Serielle Schnittstelle 
0411    	CP 30H		; und Konvertiert ASCII in BCD-Zahl
0412    	JP C,TIMEOUT
0413    	CP 3AH
0414    	JP NC,TIMEOUT
0415    	AND 0FH
0416    	RET

0417 LADE_MODE 	LD HL,2012H	; Frequenz und Betriebsmodus laden
0418    	RES 3,(HL)	; Bit 3 in Steuerregister (2012H) lschen
0419    	CALL ASCII_2BCD ; zwei Ziffern in 2000H und 2001H speichern
0420    	CALL ASCII_BCD2	; Blank wegwerfen, weitere BCD-Ziffer
0421    	CALL SWAP_A	; holen und in B speichern
0422    	LD B,A
0423    	CALL ASCII_BCD	; zweite Ziffer holen und packen 
0424    	OR B
0425    	CALL BCD2_BIN	; BCD in Binr wandeln
0426    	SUB 4H
0427    	JP Z,TIMEOUT	; Fehleingabe aussondern
0428    	JP C,TIMEOUT
0429    	LD (DE),A	; und in mit DE adressierter Speicherstelle (2002H)
0430    	INC DE		; ablegen, ist wohl Kanalnummer
0431    	CALL ASCII_BCD	; zwei weitere Ziffern holen 
0432    	CALL SWAP_A
0433    	LD B,A
0434    	CALL ASCII_BCD	; in BCD wandeln
0435    	OR B
0436    	CALL BCD2_BIN	; Und in Binr konvertieren
0437    	SUB 5H		; Fehleingaben aussondern
0438    	JP Z,TIMEOUT
0439    	JP C,TIMEOUT
0440    	LD (DE),A	; Ergebnis in mit DE adressierter Speicherstelle (2003H)
0441    	INC DE		; ablegen, ist wohl Spruchpaketlnge
0442    	CALL ASCII_BCD2	; Blank und ASCII-Ziffer holen
0443    	LD HL,2012H	; Bit 6 in Steuerregister  (2012H)lschen
0444    	RES 6,(HL)
0445    	CP 1H		; Kommando 1
0446    	JR NZ,LADE_MO1	; dann Bit 6 in Steuerregister setzen
0447    	SET 6,(HL)
0448 LADE_MO1 	CALL ASCII_BCD2	; Blank und Ziffer holen
0449    	LD (DE),A	; in mit DE adressierter Speicherstelle ablegen (2004H)
0450    	INC DE		; Erste Ziffer Weckzeit
0451    	LD B,7H
0452 LADE_MO2 	CALL ASCII_BCD	; sieben weitere Ziffern holen (die Weckzeiten)
0453    	LD (DE),A	; und in mit DE adressierten Speicherstellen ablegen
0454    	INC DE		; (2004H bis 200BH)
0455    	DJNZ LADE_MO2
0456    	CALL ASCII_BCD2	; Blank und Ziffer holen
0457    	RES 7,(HL)
0458    	CP 1H		; wenn es eine 1 war, Bit 7 in Steuerregister setzen
0459    	JR NZ,LADE_MO3
0460    	SET 7,(HL)
0461 LADE_MO3 	CALL READ_SER	; Abbruch, wenn nchstes Zeichen kein Blank 
0462    	CP 20H
0463    	JP NZ,TIMEOUT
0464    	LD IX,2022H	; IX auf Beginn 1. Tabellenspeicher
0465    	CALL GET_IXPT3	; aus weiterer Eingabe 16-Bit-Konstante 9D8 + Eingabe
				; in 2022H und 2023H speichern, ist das der erste
0466    	CALL READ_SER	; verwendete Funkkanal in Frequenztabelle 1?
0467    	CP 0FFH		; Endezeichen FFH?
0468    	JR Z,LADE_MO4	; zum Lade-Programmende
0469    	CP 20H		; kommt noch ein Blank
0470    	JP NZ,TIMEOUT
0471    	LD IX,234AH	; dann IX auf Beginn 2. Spruchspeicher 
0472    	CALL GET_IXPT3	; aus weiterer Eingabe 16-Bit-Konstante 9D8 + Eingabe
				; in 234A und 234B ablegen, ist das der erste
0473    	CALL READ_SER	; verwendete Funkkanal in Frequenztabelle 2?
0474    	CP 0FFH
0475    	JP NZ,TIMEOUT
0476 LADE_MO4 	CALL READ_SER	; zweites Endezeichen FFH?
0477    	CP 0FFH
0478    	JP NZ,TIMEOUT
0479    	LD HL,2012H	; Dann Bit 3 in Steuerregister setzen und
0480    	SET 3,(HL)	; Kommandomodus beenden
0481    	JP KOM_DECX


0482 ASCII_2BCD LD DE,2000H	; zwei ASCII-Zeichen holen und
0483    	CALL ASCII_2	; jeweils in unterem und oberem Halbbyte
0484 ASCII_2 	CALL ASCII_BCD	; speichern
0485    	LD (DE),A	; Eingaben werden in 2000H und 2001H 
0486    	CALL SWAP_A	; abgelegt
0487    	EX DE,HL
0488    	OR (HL)
0489    	EX DE,HL
0490    	LD (DE),A
0491    	INC DE
0492    	RET

0493 GET_IXPT3 	LD HL,9D8H	; in durch IX adressierter Speicherstelle
0494    	CALL READ_SER   ; die 16-Bit-Konstante aus 9D8 + Eingabe
0495    	LD D,0H		; ablegen, 9D8 ist 2520 Dezimal!?
0496    	LD E,A
0497    	ADD HL,DE
0498    	LD (IX+0H),L
0499    	LD (IX+1H),H
0500    	RET

0501 RTC_STELL 	LD IX,2012H		; Stellen der Systemuhr, Einsprung ber
0502    	RES 5,(IX+0)		; DEC_TAB Decodertabelle
0503    	XOR A
0504    	OUT (RTC_START),A	; Uhr stoppen
0505    	CALL ASCII_BCD
0506    	OUT (RTC_STD1),A
0507    	CALL ASCII_BCD
0508    	OUT (RTC_STD0),A
0509    	CALL ASCII_BCD
0510    	OUT (RTC_MIN1),A
0511    	CALL ASCII_BCD
0512    	OUT (RTC_MIN0),A
0513    	LD A,0FFH		; Uhr starten
0514    	OUT (RTC_START),A
0515 RTC_STEL1 	CALL READ_SER
0516    	CP 20H			; auf Blank warten
0517    	JR NZ,RTC_STEL1
0518    	CALL READ_SER
0519    	LD E,A
0520    	CALL READ_SER
0521    	LD D,A
0522    	LD HL,(200CH)		; Test der Prfsummen?
0523    	LD BC,(200EH)
0524    	ADD HL,BC
0525    	BIT 6,(IX+0H)
0526    	JR Z,RTC_STEL2
0527    	LD BC,(2010H)
0528    	ADD HL,BC
0529 RTC_STEL2 	XOR A
0530    	SBC HL,DE
0531 RTC_STEL3 	JP NZ,TIMEOUT
0532    	CALL READ_SER
0533    	CP 0FFH
0534    	JR NZ,RTC_STEL3
0535    	CALL READ_SER
0536    	CP 0FFH
0537    	JR NZ,RTC_STEL3
0538    	SET 5,(IX+0H)		; Bit 5 in 2012 setzen: Uhr gestellt!
0539    	JP KOM_DECX

0540 SEND_SIO1 	LD A,0FEH		; Senden ber SIO A
0541 SEND_SIO2 	CP 0FFH
0542    	JR NZ,SEND_S1
0543    	IN A,(PIO_B_DAT)	; 
0544    	BIT 2,A
0545    	JP NZ,SEND_ERR
0546 SEND_S1 	PUSH AF
0547 SEND_S2 	IN A,(SIO_A_CTRL)	; Sendepuffer leer?
0548    	BIT 2,A
0549    	JR Z,SEND_S2
0550    	POP AF
0551    	OUT (SIO_A_DAT),A	; Byte senden
0552    	RET


0553 SET_TX1 	LD A,(2003H)		; Senderfrequenz einstellen und
0554    	LD B,A			; Synczeichen senden
0555 SET_TX2 	EXX
0556    	IN A,(PIO_B_DAT)	; Bit 2 in PIO B (Sendertastung) holen
0557    	RES 2,A			; und lschen
0558    	LD B,0AH		; Hier wird Synthesizer programmiert
0559    	LD C,PIO_A_DAT		; 10 Byte ber PIO A senden
0560    	LD HL,2018H		; Frequenzwort (10 Byte) ab 2018H

0561    	EX AF,AF'		; Sind das Synchronisationszeichen?
0562    	CALL SEND_SIO1		; Zweimal 0FEH senden
0563    	CALL SEND_SIO1
0564    	EX AF,AF'

0565   		OUT (PIO_B_DAT),A	; Sendertastung aus	
0566    	PUSH BC
0567    	LD B,13H
0568 SET_TX3 	DJNZ SET_TX3		; kurze Pause
0569    	POP BC
0570    	OTIR			; Daten zum Sendesynthesizer

0571    	CALL SEND_SIO1		; 0FEH senden
0572	    	LD A,(201EH)		; Frequenzangabe in Ordnung?
0573    	CP 1FH
0574    	JP Z,FREQ_ERR
0575    	CALL SEND_SIO1		; dreimal 0FEH senden
0576    	CALL SEND_SIO1
0577    	CALL SEND_SIO1
0578    	EXX
0579 SET_TX4 	CALL SEND_SIO1		; Bei Kanalwechsel wird hier gewartet
0580    	LD A,B			; Inhalt von 2003H ist in A
0581    	CP 1H			; Wartezeit hngt von Kanalzahl ab!?
0582    	JR NZ,SET_TX7
0583    	PUSH BC
0584    	LD B,14H
0585 SET_TX5 	DJNZ SET_TX5		; kurze Pause
0586    	LD A,1FH		; Watchdog aus, beide LEDs an, Senderversorgung
0587    	OUT (PIO_B_DAT),A	; und Sendertastung ein
0588    	LD B,1AH
0589 SET_TX6 	DJNZ SET_TX6		; Kurze Pause
0590    	POP BC
0591 SET_TX7 	DJNZ SET_TX4
0592    	IN A,(PIO_A_DAT)	; Wird hier Lock Detect getestet?
0593    	BIT 5,A			; Wenn Lock Detect da, wird Bit 3
0594    	RET NZ			; in 2013H gesetzt
0595    	LD HL,2013H
0596    	BIT 3,(HL)		; War schon ein Lock Detect-Fehler
0597    	JP NZ,ENDE		; dann abbrechen
0598    	SET 3,(HL)		; sonst Fehlerbit setzen
0599    	RET

0600 KONVERT_1 	LD DE,(2016H)		; Ominses Konvertierprogramm in
0601    	LD A,(DE)		; der Sendeloop, errechnet aus der
0602    	CALL KONV_1		; Frequenztabelle (Speicher 1 oder
0603    	LD A,(DE)		; Speicher 2) die Einstellwerte des
0604    	INC DE			; Synthesizers
0605    	LD (2016H),DE		; ist wohl die Steuerung des
0606    	CALL SWAP_A		; Frequency Hopping - Betriebs
0607 KONV_1 	AND 0FH			; 
0608    	ADD A,10H		; Der Zeiger fr DE wird automatisch
0609    	LD (HL),A		; inkrementiert
0610    	INC HL
0611    	RET

0612 SENDELOOP 	LD A,(2002H)		; Das ist der Kern der Sendeschleife, hier
0613    	LD B,A			; luft die bertragung
0614 SENDELOOP1 LD HL,(2014H)		; 2014 zeigt auf Beginn Speicher
0615    	LD A,(HL)		;
0616    	CP 0FFH			; Test auf leeren Speicher
0617    	JP Z,S_LOOPENDE		; dann beenden

0618    	CALL SEND_SIO1		; Synczeichen senden
0619    	IN A,(PIO_A_DAT)
0620    	BIT 5,A			; Lock Detect testen?
0621    	JR NZ,SENDELOOP2
0622    	LD A,19H		; Warum wird hier der Sender ausgeschaltet?	
0623    	OUT (PIO_B_DAT),A
0624 SENDELOOP2 LD A,(HL)
0625    	CALL SEND_SIO2		; erstes Byte senden
0626    	INC HL
0627    	LD A,(HL)
0628   		CALL SEND_SIO2		; zweites Byte senden
0629    	INC HL

0630		PUSH HL			; da werden zwei Bytes im Sendespeicher
0631    	LD HL,201BH		; modifiziert
0632    	CALL KONVERT_1
0633    	POP HL

0634    	LD A,(HL)		; drittes Byte senden
0635    	CALL SEND_SIO2
0636    	INC HL

0637    	PUSH HL			; da werden zwei Bytes im Sendespeicher
0638    	LD HL,201DH		; modifiziert
0639    	CALL KONVERT_1
0640    	POP HL

0641 SENDELOOP3 LD A,(HL)		; Rest der Daten senden
0642    	CALL SEND_SIO2
0643    	INC HL
0644    	DJNZ SENDELOOP3

0645    	IN A,(PIO_B_DAT)
0646    	BIT 2,A
0647    	RET Z
0648    	LD (2014H),HL
0649    	RET


0650 BLOCKKONV 	LD L,(IX+0H)	; Datenblock von Binr in Packed BCD wandeln
0651    	INC IX		; IX zeigt auf Beginn Block
0652    	LD H,(IX+0H)
0653    	INC IX
0654    	LD A,0FFH	; FFXXh ist offensichtlich Endezeichen
0655    	CP H
0656    	RET Z
0657    	CALL BIN_BCD
0658    	LD A,66H	; Die Ziffern werden mit Offset versehen
0659   	 	ADD A,L		; und liegen jetzt von 66H...FFH
0660    	LD (IX+0FEH),A
0661    	LD A,66H
0662    	ADD A,H
0663    	LD (IX+0FFH),A	; Die Daten werden 256 Byte hher  
0664 	 	JR BLOCKKONV	; wieder abgelegt


0665 KOM_DEC1 	IN A,(PIO_B_DAT)	; Kommandodecoder 1, auf Startereignis
0666    	RES 2,A			; (SIO- oder Uhraktivitt) warten
0667    	OUT (PIO_B_DAT),A	; Sender sicherheitshalber aus!
0668    	OUT (RTC_START),A
0669 KOM_LP1 	CALL READ_RTC		; Uhr lesen
0670    	IN A,(PIO_B_DAT)	; Dieses Programmteil kopiert
0671    	RRA			; den Sekundeneiner in die gelbe LED
0672    	RRA			; (PIO B, Bit 1) und lsst sie blinken
0673    	SRL C
0674    	RLA
0675    	RLA
0676    	OUT (PIO_B_DAT),A
0677    	IN A,(SIO_A_CTRL)	; Zeichen auf SIO A da?
0678    	BIT 0,A
0679    	JP NZ,KOM_DEC2
0680    	IN A,(SIO_B_CTRL)	; Zeichen auf SIO B da?
0681    	BIT 0,A
0682    	JP NZ,KOM_DEC2
0683    	IN A,(SIO_A_CTRL)
0684    	BIT 3,A			; Einschalttaste gedrckt?
0685    	JP NZ,INTERRUPT		;
0686    	JR KOM_LP1

0687 RTC_WECKER LD A,(IX+0H)	; Zeitvergleich RTC mit Weckzeit
0688    	CP H		; in 2004...2007H bzw. 2008...200C
0689    	RET NZ
0690    	LD A,(IX+1H)
0691    	CP L
0692    	RET NZ
0693    	LD A,(IX+2H)
0694    	CP D
0695    	RET NZ
0696    	LD A,(IX+3H)
0697    	CP E			; bei Gleichheit ist Zero gesetzt
0698    	RET

0699 FREQ_ERR 	CALL SEND_SIO1		; Hier wird vermutlich ein Fehler in der
0700    	CALL SEND_SIO1		: Frequenzeingabe barbeitet
0701    	LD A,PIO_B_DAT
0702    	OUT (PIO_B_DAT),A
0703    	CALL ZEIT_SCHL2
0704    	LD HL,2012H
705		BIT 6,(HL)
0706 FREQ_ER1 	JR Z,FREQ_ER2
0707    	LD HL,2013H
0708    	BIT 0,(HL)
0709    	JR NZ,FREQ_ER2
0710    	SET 0,(HL)
0711    	LD A,12H
0712    	OUT (PIO_B_DAT),A
0713    	CALL ZEIT_SCHL2
0714    	LD A,(2001H)
0715    	LD (2674H),A
0716    	LD (2675H),A
0717    	JP NEUSTART

0718 FREQ_ER2 	LD HL,(2014H)
0719    	LD A,(HL)
0720    	CP 0FFH
0721    	JP Z,TEST_MEM		; Speicher mit FFH fllen
0722    	JR ENDE

0723 SEND_ERR 	CALL SEND_SIO1	; Das ist seltsam: Programm ruft sich selber auf!
0724    	CALL SEND_SIO1	; Ist das ein Fehlerausstieg?

0725 S_LOOPENDE LD A,11H		; Hier mndet Sendeloop, wenn 0FFH im
0726    	OUT (PIO_B_DAT),A	; Sendespeicher gefunden wurde
0727    	CALL ZEIT_SCHL2		; Sender und Sendetastung aus, Einschalt-
0728    	LD HL,2012H		; LED und Watchdog weiter an
0729    	BIT 6,(HL)
0730		JP Z,TEST_MEM		; Auftrag erfllt, Speicher mit FF fllen
0731    	LD HL,2013H
0732    	BIT 0,(HL)
0733    	JP NZ,TEST_MEM		; Auftrag erfllt, Speicher mit FF fllen
0734    	SET 0,(HL)
0735		Ld A,12H		; Watchdog aus, grne LED ein
0736    	OUT (PIO_B_DAT),A
0737    	CALL ZEIT_SCHL2
0738    	LD A,(2001H)
0739    	LD (2674H),A
0740    	LD (2675H),A
0741    	JP NEUSTART

0742 ENDE 	LD HL,2000H		; Programm fr immer beenden
0743    	LD DE,2001H		; RAM lschen einschlielich
0744    	LD BC,1FFFH		; Stack
0745    	LD (HL),0
0746    	LDIR
0747    	IN A,(RTC_INT)		; Uhrinterruptsystem rcksetzen
0748    	IN A,(RTC_INT)
0749    	IN A,(RTC_INT)
0750    	XOR A
0751    	OUT (RTC_INT),A		; Uhrinterrupt aus
0752    	LD A,60H		; alles ausschalten!!
0753 END_LP 	OUT (PIO_B_DAT),A	; Ende des Programms in
0754    	JR END_LP		; Endlosschleife

0755 NEUSTART 	IN A,(RTC_INT)		; Neustart nach Fehlern
0756    	IN A,(RTC_INT)
0757    	IN A,(RTC_INT)		; Uhrinterruptsystem rcksetzen
0758    	LD A,10H
0759    	OUT (PIO_B_DAT),A	; Watchdog aus
0760    	CALL ZEIT_SCHL1
0761    	LD A,5
0762    	OUT (SIO_A_CTRL),A
0763    	LD A,80H
0764    	OUT (SIO_A_CTRL),A
0765    	LD A,20H		; Ein/Aus-FF ausschalten
0766    	OUT (PIO_B_DAT),A
0767    	NOP
0768    	NOP
0769    	NOP
0770    	NOP
0771    	NOP
0772    	NOP
0773    	NOP
0774    	NOP
0775    	NOP
0776    	NOP
0777    	NOP
0778    	NOP
0779    	NOP
0780    	JP ANFANG

0781 TEST_MEM 	LD HL,2000H		; Speicher mit FFH fllen
0782    	LD DE,2001H		; und Speicher testen
0783    	LD BC,1FFFH
0784    	LD (HL),0FFH
0785    	LDIR
0786    	DEC HL
0787    	LD A,0FFH
0788    	CP (HL)
0789    	JP NZ,ENDE		; Bei Speicherfehlern Programm beenden
0790    	LD SP,3FFFH
0791    	JR NEUSTART		; sonst Neustart

0792 SENDE_FRE 	LD A,10H		; Sendefrequenz aus Steuerworten
0793    	OUT (SIO_A_CTRL),A	; berechnen
0794    	IN A,(SIO_A_CTRL)
0795    	BIT 5,A			; Batteriespannung (CTS SIO A) testen
0796    	JP NZ,ENDE
0797    	CALL MOV_ROM1		; Default-Sendefrequenz laden?
0798    	LD HL,201BH
0799   		CALL KONVERT_1		; Einstellen der aktuellen 
0800    	LD HL,201DH		; Sendefrequenz?
0801    	CALL KONVERT_1

0802    	LD B,5H
0803 SENDE_FR1 	IN A,(PIO_A_DAT)	; Warum hier 5 Lesezugriffe, die
0804    	DJNZ SENDE_FR1		; je einen Takt fr den Synthesizer
0805    	LD B,1H			; erzeugen
0806    	CALL SET_TX2
0807    	LD A,1DH		; Watchdog aus, Senderversorgung ein
0808    	OUT (PIO_B_DAT),A	; Sender tasten, gelbe LED ein
0809    	LD B,5DH
0810 SENDE_FR2  DJNZ SENDE_FR2		; Pause
0811    	IN A,(PIO_A_DAT)
0812    	AND 60H			; Lock Detect und andere Schaltfunktion
0813    	CP 20H			; testen
0814    	LD A,19H		; Sender und Sendertastung wieder aus
0815    	OUT (PIO_B_DAT),A
0816    	RET			; Z-Bit enthlt Testergebnis

0817 ZEIT_SCHL3 CALL ZEIT_SCHL1
0818 ZEIT_SCHL2 CALL ZEIT_SCHL1

0819 ZEIT_SCHL1 LD BC,Q0000	; Zeitschleife
0820 	 ZEIT_S DEC BC
0821    	LD A,B
0822 	   	OR C
0823    	JR NZ,ZEIT_S
0824    	RET

0825 S_AUFTR3 	CALL SIO_A_INI1		; der Sendeauftrag ist vorbereitet
0826    	LD A,19H
0827    	OUT (PIO_B_DAT),A	; grne LED und Senderversorgung ein
0828    	CALL READ_RTC
0829    	LD IX,2004H
0830    	CALL RTC_WECKER		; Weckzeit 1 erreicht?
0831		JR NZ,S_AUFTR4
0832    	LD HL,2013H		; dann Bit 1 in 2013H setzen
0833    	SET 1,(HL)
0834 S_AUFTR4 	LD A,10H		; Auf Minuteninterrupt warten
0835    	OUT (SIO_A_CTRL),A
0836    	IN A,(SIO_A_CTRL)
0837    	BIT 3,A
0838    	JR NZ,S_AUFTR4
0839    	LD HL,2012H
0840    	LD A,(HL)		; steht Auftrag an?
0841    	AND 0BH
0842    	CP 0BH
0843    	JP NZ,ENDE
0844    	BIT 7,(HL)
0845    	JR Z,S_AUFTR7

0846 S_AUFTR5 	LD HL,2013H		; Hier wird entschieden, ob 
0847    	LD DE,2022H		; Speicher 1 (ab 2022), Speicher 2 (ab 234A)
0848    	BIT 0,(HL)		; oder Speicher 3 (ab 2672)
0849    	JR Z,S_AUFTR6		; bearbeitet wird
0850    	LD DE,234AH
0851 S_AUFTR6 	LD (2016H),DE
0852    	LD DE,2672H
0853    	LD (2014H),DE 
0854    	LD HL,2012H
0855    	RES 6,(HL)
0856    	JP S_AUFTR13
0857 S_AUFTR7 	BIT 6,(HL)
0858    	JR Z,S_AUFTR5
0859    	LD HL,2013H
0860    	BIT 1,(HL)
0861    	JR NZ,S_AUFTR5
0862    	LD DE,2022H
0863    	BIT 0,(HL)
0864    	JP Z,S_AUFTR12
0865    	LD DE,234AH
0866    	JP S_AUFTR12

0867 KOM_DECX 	LD SP,3FFFH		; Kommandodecoder-Fehlerausstieg?
0868    	LD HL,2012H
0869    	LD A,(HL)
0870    	AND K001F
0871    	CP K001F
0872    	JR Z,S_AUFTRAG

0873 TIMEOUT 	LD SP,3FFFH		; Stack geradebiegen und im KOM_DEC1
0874    	JP KOM_DEC1		; auf neues Startereignis warten


0875 S_AUFTRAG 	BIT 6,(HL)		; Sendeauftrag bearbeiten
0876  		JR Z,S_AUFTR1		; Bit 6 in 2012 gesetzt: Speicher 1
0877    	BIT 2,(HL)		; senden
0878    	JR Z,TIMEOUT		; Bit 2 gesetzt: Auftrag beenden
0879    	LD IX,234AH		; Startadresse Speicher 2
0880    	CALL BLOCKKONV

0881 S_AUFTR1 	LD IX,2022H		; Startadresse Speicher 1
0882		LD (2016H),IX
0883    	CALL BLOCKKONV		; Binr in BCD wandeln
0884    	IN A,(RTC_INT)		; Interruptsystem Uhr lschen
0885    	IN A,(RTC_INT)
0886    	IN A,(RTC_INT)
0887   	 	LD HL,ROM_TAB3		; Gertekennung ?
0888    	LD DE,2672H
0889    	LD BC,5H
0890    	LDIR
0891    	LD DE,2674H
0892    	LD A,(2000H)		; Inhalt von 2000 wird in Kennstring
0893    	LD (DE),A		; zweimal eingebaut
0894    	INC DE
0895    	LD (DE),A
0896    	XOR A
0897    	OUT (PIO_B_DAT),A	; LEDs und Senderstromversorgung aus
0898 S_AUFTR2 	IN A,(SIO_A_CTRL)	; 
0899    	BIT 3,A
0900    	JP NZ,S_AUFTR3		; Was wird hier geprft?
0901    	CALL READ_RTC
0902   	 	LD A,B
0903    	OR A
0904    	JR NZ,S_AUFTR2
0905    	LD A,0CH		; Uhr auf Interrupt alle Minute stellen 
0906    	OUT (RTC_INT),A
0907    	LD A,10H
0908    	OUT (PIO_B_DAT),A	; Impuls auf Bit 5 von PIO B ausgeben?
0909    	XOR A
0910    	OUT (PIO_B_DAT),A
0911    	JP S_AUFTR8

0912 INTERRUPT 	LD SP,3FFFH		; Softwareinterrupt durch Uhr 
0913    	LD HL,2012H		; oder Einschalttaste
0914    	LD A,(HL)		; steht noch ein Sendeauftrag an?
0915    	CP 0BH
0916    	JR Z,S_AUFTRAG
0917    	JP TIMEOUT

					; Diese Modi dienen zur Datensendung
0918 SIO_A_INI1	PUSH HL			; Initialisierung SIO A, TX ein
0919    	PUSH BC			; Taktteilung CLock/1
0920    	LD C,SIO_A_CTRL		; ergibt 38,4 KBit/sec
0921    	LD B,8			; 8 Bit Wortlnge
0922    	LD HL,SIO_A_TAB1	; und RX ein
0923    	OTIR
0924    	POP BC
0925    	POP HL
0926    	RET
0927 SIO_A_TAB1	DB 18H,18H	
0928    	DB 04H
0929    	DB 0CH
0930    	DB 05H
0931    	DB 68H
0932    	DB 03H
0933    	DB 0C1H

0934 SIO_A_INI2	PUSH HL			; Initialisierung SIO A, RX aus
0935    	PUSH BC			; sonst wie oben
0936    	LD C,SIO_A_CTRL
0937   		LD B,8
0938    	LD HL,SIO_A_TAB2
0939    	OTIR
0940    	POP BC
0941    	POP HL
0942    	RET

0943 SIO_A_TAB2	DB 18H,18H	
0944    	DB 04H
0945    	DB 0CH
0946 		DB 05H
0947    	DB 68H
0948    	DB 03H
0949    	DB 0C0H

0950 ROM_TAB1	DB 10H,10H
0951    	DB 1EH,16H
0952    	DB 18H,1BH
0953    	DB 18H
0954    	DB 1FH
0955    	DB 10H
0956    	DB 00H

0957ROM_TAB2    DB 086H
0958    	DB 08BH
0959ROM_TAB3   	DB 0FEH
0960    	DB 0C7H
0961    	DB 000H
0962    	DB 000H
0963    	DB 0FEH


				; Das ist der Kommandodecoder
0964 DEC_TAB   	DW 0326H	; LADE_MODE Frequenz und Betriebsart laden
		DW 0260H	; L_TABELLE1 Frequenztabelle 1 laden (400 Zeichen)
		DW 0289H	; L_TABELLE2 Frequenztabelle 2 laden (400 Zeichen)
		DW 01C1H	; L_SPRUCH   Spruchspeicher laden (6400 Zeichen)
		DW 03E3H	; RTC_STELL Systemuhr stellen



				; ab hier scheinen die Test- und
				; Abgleich-Hilfen zu liegen
0972 GET_IXPT2 CALL GET_IXPTR	; zweimal hintereinander 16-Bit-Konstante
				; aus 9D8H + Eingabe ablegen
0973 GET_IXPTR 	CALL READ_SER	; In durch IX adressierte 16Bit-Konstante
0974 GET_IXP 	LD E,A		; 9D8H + Eingabe (von SIO) ablegen
0975    	LD D,0H
0976    	LD HL,9D8H
0977    	ADD HL,DE
0978    	LD (IX+0H),L
0979    	INC IX
0980    	LD (IX+0H),H
0981    	INC IX		; IX zeigt auf Nachfolgeadresse
0982    	RET


0983 TX_TEST_A 	CP 7H		; Fortsetzung Kommandodecoder
0984    	JP NZ,TX_TEST_B	; Aufruf mit Eingabe 7, das ist ein
0985    	LD SP,4000H	; Testmodus fr die bertragung
0986    	LD IX,2022H
0987    	CALL GET_IXPT2	; In 2022 steht 9D8H + Eingabe 1
				; In 2024 dann 9D8H + Eingabe 2
0988    	LD A,2EH
0989    	LD (IX+0H),A	; in 2025 steht 2EH
0990		LD A,0EH
0991    	LD (IX+1H),A	; in 2026 steht 0EH
0992    	LD A,0FFH
0993    	LD (IX+2H),A	
0994    	LD (IX+3H),A	; in 2027 und 2028 steht FFH

0995    	LD IX,2022H	; Zeiger zurckstellen
0996    	CALL BLOCKKONV

0997    	CALL READ_SER	; Nchstes Zeichen in 2677
0998    	LD HL,2677H
0999    	LD (HL),A	
1000    	LD DE,2678H	; die folgenden 300 Byte damit 
1001    	LD BC,12CH	; vollschreiben
1002    	LDIR

1003    	LD A,60H	; 60H nach 2002H
1004    	LD (2002H),A
1005    	LD A,5CH	; 5CH nach 2003H
1006    	LD (2003H),A
1007    	CALL SIO_A_INI1

1008 TX_TESTLP 	LD IY,2677H	; Speicher senden
1009    	LD (2014H),IY	; Speicheranfang nach IY
1010    	LD IX,2022H
1011    	LD (2016H),IX
1012    	CALL SENDELOOP
1013    	CALL SET_TX1
1014    	CALL SENDELOOP
1015		CALL SET_TX1
1016    	LD A,10H
1017    	OUT (SIO_A_CTRL),A
1018    	IN A,(SIO_A_CTRL)
1019    	BIT 3,A			; Auf Tastendruck/Uhrinterrupt warten?
1020    	JR Z,TX_TESTLP
1021    	CALL ZEIT_SCHL1
1022 TX_TEST1 	LD A,10H		; warten, bis Uhrinterrupt weg?	
1023    	OUT (SIO_A_CTRL),A
1024    	IN A,(SIO_A_CTRL)
1025    	BIT 3,A
1026    	JR NZ,TX_TEST1
1027    	CALL ZEIT_SCHL1
1028    	CALL PIO_INIT
1029    	JP KOM_DECX

1030 TX_TEST_B 	CP 5H			; Aufruf mit Eingabe 5, zweiter Testmodus
1031    	JP NZ,KOM_DECX		; 
1032    	LD SP,4000H
1033    	LD IX,2022H
1034    	LD (2016H),IX
1035    	CALL READ_SER		; zwei "leere" Lesebefehle
1036    	CALL READ_SER
1037    	CALL READ_SER
1038    	LD (2002H),A
1039    	LD A,1BH		; Senderversorgung und beide LEDs ein
1040    	OUT (PIO_B_DAT),A	; Watchdog aus
1041    	CALL TEST_ABB
1042 TEST_B1 	CALL GET_IXPTR

1043 TEST_B_LP 	LD A,0FFH
1044    	LD (IX+0H),A
1045    	LD (IX+1H),A
1046    	LD IX,2022H
1047    	CALL BLOCKKONV
1048    	CALL SIO_A_INI2
1049    	LD HL,201BH
1050    	CALL KONVERT_1
1051    	LD HL,201DH
1052    	CALL KONVERT_1
1053    	LD B,0AH
1054    	LD C,10H        	; Hier wird auch Sender programmiert
1055    	LD HL,2018H
1056    	OTIR
1057    	CALL SEND_SIO1
1058    	CALL SEND_SIO1
1059    	CALL SEND_SIO1
1060    	CALL SEND_SIO1
1061    	CALL SEND_SIO1
1062    	CALL SEND_SIO1
1063    	CALL SEND_SIO1
1064    	CALL SEND_SIO1
1065    	LD A,5H
1066    	OUT (SIO_A_CTRL),A
1067    	LD A,10H
1068    	OUT (SIO_A_CTRL),A
1069    	LD A,1FH
1070    	OUT (PIO_B_DAT),A
1071    	LD A,(2002H)
1072    	CP 30H
1073    	JR Z,TEST_B2
1074    	CP 31H
1075    	JR NZ,TEST_B3
1076    	LD A,5H
1077    	OUT (SIO_A_CTRL),A
1078    	LD A,28H
1079    	OUT (SIO_A_CTRL),A
1080 TEST_B2 	LD IX,2022H
1081    	LD (2016H),IX
1082    	CALL TEST_ABB
1083    	LD A,1BH		; beide LEDs an, Senderversorgung ein
1084    	OUT (PIO_B_DAT),A	; Watchdog aus
1085    	CALL GET_IXPTR
1086    	JP TEST_B_LP

1087 TEST_ABB 	IN A,(SIO_B_CTRL)	; Test auf Abbruchkommando auf SIO B
1088   		BIT 0,A			; Warten auf Zeichen
1089    	JR Z,TEST_ABB
1090    	IN A,(SIO_B_DAT)	; Bei Null zurckkehren
1091    	CP 0H
1092    	RET Z
1093    	CP 0FFH			; Bei FFH abbrechen
1094    	JR NZ,TEST_ABB		; alles andere ignorieren
1095    	LD A,13H		; Beide LEDs auf Dauerlicht
1096    	OUT (PIO_B_DAT),A	; Watchdog aus
1097    	JP KOM_DECX

1098 TEST_B3 	LD A,4			; SIO B uminitialiseren
1099    	OUT (SIO_A_CTRL),A
1100    	LD A,4
1101 		OUT (SIO_A_CTRL),A
1102    	LD A,5
1103    	OUT (SIO_A_CTRL),A
1104    	LD A,68H
1105    	OUT (SIO_A_CTRL),A

1106 TEST_B5 	LD A,8			; Solange senden, wie kein Zeichen auf SIO B
1107    	CALL SEND_SIO2
1108    	IN A,(SIO_B_CTRL)
1109    	BIT 0,A
1110    	JR Z,TEST_B5
1111    	IN A,(SIO_B_DAT)
1112    	CP 0H			; Null setzt Testschleife B fort
1113    	JP Z,TEST_B1
1114    	CP 0FFH
1115    	JR NZ,TEST_B5		; FFH bricht ab
1116    	LD A,13H		; Beide LEDs auf Dauerlicht
1117    	OUT (PIO_B_DAT),A	; Watchdog aus
1118    	CALL SIO_AB_INI
1119    	JP KOM_DECX

