;~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
;~ PICREG.INC updated: Feb '08		~
;~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
;
PIC54		equ     1FFh            ; Define Reset Vectors
PIC55		equ     1FFh
PIC56		equ     3FFh
PIC57		equ     7FFh
PIC59		equ	7FFh
PIC71		equ     000h
PIC84		equ	000h
PIC508		equ	000h
IntVector	equ	004h		; 16C71/84 Interrupt vector address.
					;-->SFR registers for the PIC16CXX series:
f0		equ	00h		; indirect file register.
indf		equ	00h		; renewed f0.
rtcc    	equ     01h     	; rtcc.
tmr0		equ	01h		; renewed rtcc.
opt		equ	01h		; option register.
pc      	equ     02h     	; programm counter.
pcl     	equ     02h     	; programm counter low byte.
status  	equ     03h     	; status register.
fsr     	equ     04h     	; file select register.
porta   	equ     05h     	; porta I/O.
trisa		equ	05h		; porta direction register.
osccal		equ	05h		; oscillator calibration for PIC12CXXX series.
portb   	equ     06h     	; portb I/O.
trisb		equ	06h		; portb direction register.
gpio		equ	06h		; I/O port for PIC12CXXX series.
portc   	equ     07h     	; portc I/O.
trisc		equ	07h		; portc direction register.
portd   	equ     08h     	; portd I/O.
trisd		equ	08h		; portd direction register.
porte   	equ     09h     	; porte I/O.
trise		equ	09h		; porte direction register.

					;-->FSR's for PIC16C71/84:
adcon0		equ     08h		; A/D control and status register.
adcon1		equ     08h     	; A/D control register.
eedata		equ	08h		; EEprom data register.
eecon1		equ	08h		; EEprom control register #1.
adres		equ     09h     	; A/D result register.
eeadr		equ	09h		; EEprom address register.
eecon2		equ	09h		; EEprom control register #2.
pclath		equ     0Ah     	; Programm counter 5 MSBits.
intcon		equ     0Bh     	; Interrupt control register.
					;-->Status Register Bits:
cy		equ     0h		; carry bit.
dc		equ     1h		; decimal carry bit.
ze		equ     2h		; zero bit.
pd		equ     3h		; power down bit.
to		equ     4h		; timeout bit.
pa0		equ     5h      	; Page address0 selection bit.
pa1		equ     6h      	; Page address1 selection bit.
pa2		equ     7h      	; Page address2 selection bit.
rp0		equ     5h      	; Register page select bit0.
rp1		equ     6h      	; Register page select bit1.
irp		equ     7h      	; Register page select bit for indirect addr.
gpwuf		equ	7h		; reset bit.
					;-->intcon Interrupt register bits:
gie		equ     7h      	; global interrupt enable bit.
adie		equ     6h      	; adie A/D interrupt enable bit.
eeie		equ	6h		; eeie EEprom interrupt enable bit.
t0ie		equ     5h      	; tmr0 overflow interrupt enable bit.
inte		equ     4h      	; intf interrupt enable bit.
rbie		equ     3h      	; rbif interrupt enable bit.
t0if		equ     2h      	; tmr0 overflow interrupt flag.
intf		equ     1h      	; interrupt flag on INT input portb,0.
rbif		equ     0h      	; interrupt flag on portb,4..7 change.
					;-->A/D conversion control bits for PIC16C71:
adcs1		equ     7h      	; A/D conversion clock select1.
adcs0		equ     6h      	; A/D conversion clock select0.
chs1		equ     4h      	; Analog channel select bit1.
chs0		equ     3h      	; Analog channel select bit0.
go		equ     2h      	; A/D conversion start bit.
adif		equ     1h      	; A/D complete interrupt flag.
adon		equ     0h      	; A/D on/off flag.
					;-->A/D conversion control register bits:
pcfg1   	equ     1h      	; port config bit for A/D converter.
pcfg0   	equ     0h      	; port config bit for A/D converter.
					;-->PIC16x84 EEprom bits:
rd		equ	0h		; eeprom read flag.
wr		equ	1h		; eeprom write flag.
wren		equ	2h		; eeprom write enable flag.
wrerr		equ	3h		; eeprom write error flag.
eeif		equ	4h		; eeprom interrupt flag.
					;-->Boolean bits:
lsb     	equ     0h		
msb     	equ     7h
true    	equ     1h
false   	equ     0h
Err		equ	7h

;*********************** 
;* Handy Bits	       * 
;*********************** 
					;
true		equ	1
false		equ	0

_BODEN_ON                    EQU     H'3FFF'
_BODEN_OFF                   EQU     H'3FBF'
_CP_ALL                      EQU     H'03FF'
_CP_75                       EQU     H'17FF'
_CP_50                       EQU     H'2BFF'
_CP_OFF                      EQU     H'3FFF'
_DATA_CP_ON                  EQU     H'3EFF'
_DATA_CP_OFF                 EQU     H'3FFF'
_PWRTE_OFF                   EQU     H'3FFF'
_PWRTE_ON                    EQU     H'3FF7'
_WDT_ON                      EQU     H'3FFF'
_WDT_OFF                     EQU     H'3FFB'
_LVP_ON                      EQU     H'3FFF'
_LVP_OFF                     EQU     H'3F7F'
_MCLRE_ON                    EQU     H'3FFF'
_MCLRE_OFF                   EQU     H'3FDF'
_ER_OSC_CLKOUT               EQU     H'3FFF'
_ER_OSC_NOCLKOUT             EQU     H'3FFE'
_INTRC_OSC_CLKOUT            EQU     H'3FFD'
_INTRC_OSC_NOCLKOUT          EQU     H'3FFC'
_EXTCLK_OSC                  EQU     H'3FEF'
_LP_OSC                      EQU     H'3FEC'
_XT_OSC                      EQU     H'3FED'
_HS_OSC                      EQU     H'3FEE'

;
;              *** end ***

