;****************************************************************
;*   Trls43a.asm Telegrafenrelais Simulator  Aug2024		*
;*   By Marc Simons 			Cryptomuseum		*
;*   Rev.1+WDT	PIC12C508A oscillator INT, WDT on, ~4MHz	*
;*   B A S I C   O P E R A T I O N  E X P L A N A T I O N 	*
;****************************************************************
;
; This assembly file will simulate exact timing for the Trls43a2 Telegrafenrelais
; for the Siemens T52 Geheimschreiber.
; With 30V applied to the coils in series, it takes 2,8mS for complete switch-over, including dead time.
; T-deadtime <= 1,8mSec, we have choosen 1,5mSec here, well within spec.
; T-magnet <= 1 mSec, we have choosen 0,75mSec here, well within spec.
; Max switch frequency = ((1,5mSec + 0,75mSec + 100uSec + 100uSec)*2)^-1 = 117,6Hz and this is a realistic value.
;
; Created with MPLAB 8,92 which is the latest version with the decent assembler.
;
LIST		P=12F508 , C=75 , F=INHX8M	; define processor that we wanna use.
include	"c:\mplab\picreg.inc"			; include standard 12Fxxx register set.
;
__config B'000000011110' ; H'01E'		; MCLR to gpio3, no CP, WDT Enabled and INTRC-oscillator selected (xxxx xxx1 1110) 
;
;  ======= Usage of Port Bits ======================
;
						;-->GPIO file I/O definitions:


#define		CoilNegIn	gpio,0		; Negative coil drive detect input
#define		CoilPosIn	gpio,1		; Positive coil drive detect -input.
#define		WdtLedOut	gpio,2		; Watchdog LED output.
#define		unused		gpio,3		; Unused Pin (due to VPP, has /MCLR connected)
#define		ContactRaOut	gpio,4		; Contact Ra output to OPTOMOS OPTO1.
#define		ContactRbOut	gpio,5		; Contact Rb output to OPTOMOS OPTO2.
				;

				;-->Declaration of some variables in RAM used into Main Programm:
ByteCntReg	equ	010h	; Serial Tx byte count register.
CharPointer	equ	011h	; Serial Tx character pointer.
BaudDelayReg	equ	012h	; Baud rate generation delay.
SerDumpReg	equ	013h	; Serial Character Dump register.
SerBitCntReg	equ	014h	; Serial Bit Counter Register.

				;-->Declaration of some variables in RAM used into Routines:
				;
wait1		equ	015h	; delay variable.
wait2   	equ     016h	; delay variable.
wdwait1		equ	017h	; Wdt LED blink delay variable
wdwait2		equ	018h	; Wdt LED blink delay variable
wdwait3		equ	019h	; Wdt LED blink delay variable
;
;**************************************************************************
;*                       Start Main Programm!!!!!!                        *
;**************************************************************************
		org	0000h			;
		goto	InitMicrochip		; ...start main programm at address 0100h!
						;
		org     0090h			; here is where the main programm starts.
						;-->Create nice startup sequence:
InitMicrochip	call    InitPortsAndWdt		; initialize ports and other important stuff. All outputs to '0'.

		call	Wait100mSec		; Let the host system (T52 Geheimschreiber) startup without any contact engaged...
;~~~~~~~~~~~~~~~~~~
;~ Positive Drive ~
;~~~~~~~~~~~~~~~~~~
RelayLoopPos	call	InitPorts		; redefine IO's and do a clrwdt as well.
		call	Wait100uSec		
		bsf	ContactRbOut		; Contact Rb disengage...('0'is on, '1' is off)
		call	WaitDeadTime		; Emulate contact movement delay.
		bcf	ContactRaOut		; drive Ra contact, engaged now ('0'is on, '1' is off).
		call	Wait100uSec		; Minimum engaged time delay.


LoopPosHang	clrwdt	
		call	WdtLedBlink
		btfss	CoilNegIn		; is there a negative coil drive? OPTO4 output driven low?
		call	WaitMagnetTime		; yes, delay to simulate core magnetisation.
		btfss	CoilNegIn		; is there still a negative coil drive? Not a glitch? OPTO4 output driven low?
		goto	RelayLoopNeg		; yes, switch contact.
		goto	LoopPosHang		; no, it was a glitch, stay in this loop.		
						;
;~~~~~~~~~~~~~~~~~~
;~ Negative Drive ~
;~~~~~~~~~~~~~~~~~~
RelayLoopNeg	call	InitPorts		; redefine IO's and do a clrwdt as well.
		call	Wait100uSec		
		bsf	ContactRaOut		; Contact Ra disengage...('0'is on, '1' is off)
		call	WaitDeadTime		; Emulate contact movement delay.
		bcf	ContactRbOut		; drive Rb contact, engaged now ('0'is on, '1' is off).
		call	Wait100uSec		; Minimum engaged time delay.

LoopNegHang	clrwdt
		call	WdtLedBlink
		btfss	CoilPosIn		; is there a positive coil drive? Not a glitch? OPTO1 output driven low?
		call	WaitMagnetTime		; yes, delay to simulate core magnetisation.
		btfss	CoilPosIn		; is there still a positive coil drive? OPTO1 output driven low?
		goto	RelayLoopPos		; yes, switch contact.
		goto	LoopNegHang		; no, it was a glitch, stay in this loop.
;
;	
;*********************************
;*   End of main programm	 *
;*********************************
;
;~~~~~~~~Routines~~~~~~~~Routines~~~~~~~~Routines~~~~~~~~Routines~~~~~~~~Routines~~~~~~~~
;Routines~~~~~~~~Routines~~~~~~~~Routines~~~~~~~~Routines~~~~~~~~Routines~~~~~~~~Routines
						;
						;
		org     0010h	 		; routines start at 0010h!
						;
;~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
;~ Init Reg's + Watchdog + ports.				~
;~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
InitPortsAndWdt	clrf	status			; make all status flags default.
		clrf	tmr0			; before we jiggle with the WDT, clear the timer!
		clrf	gpio			; kill all outputs period.
						;-->Define opion bits:
		movlw	B'11001111'		; prescaler to WDT, WDT timeout to maximum, approx 2.3Sec.
		option				; no weak pullup on gpio's.
						;
InitPorts	clrwdt				; watchdog reset.
		movlw	B'00001011'		; gpio0 and gpio1 and gpio3 are inputs,rest is output.
						; watch: '0'=output and '1' is input.
		tris	gpio			; define gpio behaviour.
		retlw   0
						;
;~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
;~ Wait100mSec --> delay routines. (with clrwdt!)		~
;~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
Wait100mSec	movlw	.130			; (((3x256)x130)+(3x130))x1.1085uSec=100mSec
		movwf	wait2
		clrwdt				; watchdog reset! (Actually, bit of dirty here)
w100loop	decfsz 	wait1
		goto	w100loop
		decfsz	wait2
		goto	w100loop
		retlw	0
						;
;~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
;~ WaitMagnetTime --> delay routine to simulate coil core.	~
;~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
WaitMagnetTime	movlw	.1			; (((3x256)x1)+(3x1))x1uSec=0,75mSec
		movwf	wait2
wmagnettimeloop	decfsz 	wait1
		goto	wdeadtimeloop
		decfsz	wait2
		goto	wmagnettimeloop
		retlw	0
						;
;~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
;~ WaitDeadTime --> delay routine to simulate dead time.	~
;~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
WaitDeadTime	movlw	.2			; (((3x256)x2)+(3x2))x1uSec=1,5mSec
		movwf	wait2
wdeadtimeloop	decfsz 	wait1
		goto	wdeadtimeloop
		decfsz	wait2
		goto	wdeadtimeloop
		retlw	0
						;
;~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
;~ Wait100uSec --> delay routines. (with clrwdt!)		~
;~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
Wait100uSec	movlw	.13			; (((3x256)x13)x1uSec=100mSec
		movwf	wait1
w100uloop		decfsz 	wait1
		goto	w100uloop
		retlw	0
						;
;~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
;~ WdtLedBlink --> Watchdog Indicator				~
;~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
WdtLedBlink	decfsz	wdwait1
		retlw	0
		bcf	wdwait2,7
		bcf	wdwait2,6
		decfsz	wdwait2
		retlw	0
		incf	wdwait3,1

		movlw	B'00000011'
		xorwf	wdwait3,0
		btfsc	status,ze
		bcf	WdtLedOut
		btfss	status,ze
		bsf	WdtLedOut

		btfsc	wdwait3,3
		clrf	wdwait3

		retlw	0
;
		end

